; FASM source code
; http://flatassembler.net/
;
; logdmprn.asm
; (c) SysTools 2019
; http://systools.losthost.org/
;
; NewsMaster / PrintMaster virtual printer driver logs dumper
; This printer driver tested and compatible with NewsMaster version 1.0, 1.5 and II.
; Set up any printer driver in NMCONFIG.EXE and replace NEWS.PRN file in the program
; directory with compiled binary file of this virtual printer driver.
; LOGDMPRN.BIN => NEWS.PRN
;
; WARNING!
; Printer driver will be loaded via DOS Fn 04B03H (Load Overlay) to tiny static buffer.
; This buffer size only 1200 bytes long in NewsMaster 1.0.
; Because of that the driver must be as small as possible.
; For example:
; 1. Largest driver CGP220.PRN size is 1192 bytes and it's safe to use.
; 2. Driver in 1384 bytes long are already too big and will cause the program to crash.
; 3. Note that size of the driver IBMCMPCT.PRN is 1664 bytes (bigger than 1200) but it's
;    an .EXE file and amount of bytes it takes in the memory will be less than the file size.

; no "org 0100h" here - it's an overlay file
use16

; these jumps MUST be short jumps (2 bytes)
jmp @LnPitch8 ; 1
jmp @LnPitch6 ; 2
jmp @PrintRow ; 3
jmp @ResetAll ; 4
jmp @SkipPage ; 5
jmp @SkipLine ; 6

; call order for each page:
; [4] ResetAll
; [1] LnPitch8
; [3] PrintRow (for each row)
; [5] SkipPage

; -----------------------------------------------------------------------------

; and here long calls can be used

@LnPitch8:
  mov  dx, _LnPitch8
  mov  cx, 10d
  call @DumpLogs
  xor  ax, ax
  retf

@LnPitch6:
  mov  dx, _LnPitch6
  mov  cx, 10d
  call @DumpLogs
  xor  ax, ax
  retf

@PrintRow:
  ; save al for later usage
  push ax
  ; print cx (data size)
  mov  ax, cx
  mov  cx, 4d
  mov  di, _PrintRow + 9d
  call @ToHex
  ; print al (line flag)
  pop  ax
  mov  cx, 2d
  mov  di, _PrintRow + 14d
  call @ToHex
  ; print current row
  inc [_rows]
  mov ax, [_rows]
  mov cx, 4d
  mov di, _PrintRow + 18d
  call @ToHex
  ; and now output
  mov  dx, _PrintRow
  mov  cx, 25d
  call @DumpLogs
  xor  ax, ax
  retf

@ResetAll:
  mov  dx, _ResetAll
  mov  cx, 10d
  call @DumpLogs
  xor  ax, ax
  ; reset rows count
  mov [_rows], ax
  retf

@SkipPage:
  mov  dx, _SkipPage
  mov  cx, 10d
  call @DumpLogs
  xor  ax, ax
  retf

@SkipLine:
  mov  dx, _SkipLine
  mov  cx, 10d
  call @DumpLogs
  xor  ax, ax
  retf

; -----------------------------------------------------------------------------

@DumpLogs:
  ; save for later usage
  push dx
  push cx
  ; try to open file
  mov  dx, _name
  mov  al, 002h
  mov  ah, 03Dh
  int  021h
  jnc  @f
  ; failed to open - try to create
  mov  dx, _name
  xor  cx, cx
  mov  ah, 03Ch
  int  021h
  ; failed to create - exit
  jc   @DumpLogs_ret
  @@:
  ; save file handle
  push ax
  ; seek to file end
  mov  bx, ax
  xor  cx, cx
  xor  dx, dx
  mov  al, 002h ; from file end
  mov  ah, 042h
  int  021h
  ; append data to file
  pop  bx
  ; saved before
  pop  cx
  pop  dx
  push dx
  push cx
  push bx
  mov  ah, 040h
  int  021h
  ; close file
  pop  bx
  mov  ah, 03Eh
  int  021h
@DumpLogs_ret:
  pop cx
  pop dx
  retn

; -----------------------------------------------------------------------------

@ToHex:
  test cx, cx
  jz   @ToHex_ret
  add  di, cx
@conv:
  dec  di
  mov  dl, al
  shr  ax, 004h
  and  dl, 00Fh
  cmp  dl, 9d
  jbe  @f
  add  dl, 'A' - '0' - 10d
@@:
  add  dl, '0'
  mov  [di], dl
  loop @conv
@ToHex_ret:
  retn

; -----------------------------------------------------------------------------

; data area
_rows dw 0
_name db 'LOGSDUMP.LOG',0
_LnPitch8 db 'LnPitch8',13,10
_LnPitch6 db 'LnPitch6',13,10
_PrintRow db 'PrintRow ???? ?? (????)',13,10
_ResetAll db 'ResetAll',13,10
_SkipPage db 'SkipPage',13,10
_SkipLine db 'SkipLine',13,10
