; FASM source code
; http://flatassembler.net/
;
; epson_fx.asm
; (c) SysTools 2019
; http://systools.losthost.org/
;
; NewsMaster / PrintMaster Epson *X compatible printer driver source codes.
; Source codes restored by disassembling original driver file called "EPSON-FX.PRN".
; This source code has no optimization of any kind because it sole purpose
; is to be instruction-exact to the original printer driver file.
; Not byte-exact since there are difference in 13 bytes with the original file
; due to fact that some assembler instruction can be written in a different ways,
; for example command "xor al, al" can be 32 C0 (original file) or 30 C0 (FASM).

; no "org 0100h" here - it's an overlay file
use16

; these jumps MUST be short jumps (2 bytes)
jmp @LnPitch8 ; 1
jmp @LnPitch6 ; 2
jmp @PrintRow ; 3
jmp @ResetAll ; 4
jmp @SkipPage ; 5
jmp @SkipLine ; 6

@LnPitch8:
  lea  si, [_SeqSpacing8]
  mov  cx, 4d
  nop
  call @PrintSeq
  retf

@LnPitch6:
  lea  si, [_SeqSpacing6]
  mov  cx, 4d
  nop
  call @PrintSeq
  retf

; input:
; es:si - image buffer address
; cx - size for image buffer in bytes
; al - non-zero if printing 0x0A at the end required after 0x0D
@PrintRow:
  mov  [_BufSeg], es
  mov  [_BufOfs], si
  mov  [_BufLen], cx
  mov  [_PrnFlg], al
  mov  di, si
  add  di, cx
  dec  di
  ; al = 0
  xor  al, al
  std
  ; find non-al byte at es:di
  repe scasb
  ; if line empty - skip it
  jz   @f
  ; print only non-empty data (trim empty tail)
  inc  cx
  mov  word [_Seq960LCols + 2], cx
  call @PrintHead
  jnz  @prnt_data_ret
  mov  si, [_BufOfs]
  mov  cx, word [_Seq960LCols + 2]
  call @PrintBuf
  jnz @prnt_data_ret
  @@:
  call @PrintLine
  jnz  @prnt_data_ret
  call @CheckKey
  or   ax, ax
  @prnt_data_ret:
  retf

@ResetAll:
  lea  si, [_SeqPrnReset]
  mov  cx, 7d
  nop
  call @PrintSeq
  retf

@SkipPage:
  mov  al, 00Ch
  call @PrintChr
  retf

@SkipLine:
  mov  al, 00Ah
  call @PrintChr
  retf

@PrintSeq:
  cld
  @@:
  lodsb
  call @PrintChr
  loope @b
  retn

@PrintBuf:
  cld
  @@:
  lods byte [es:si]
  call @PrintChr
  loope @b
  retn

@PrintChr:
  push dx
  xor  dx, dx
  xor  ah, ah
  int  017h
  pop  dx
  test ah, 029h
  retn

@PrintLine:
  mov  al, 00Dh
  call @PrintChr
  jnz  @f
  test [_PrnFlg], 0FFh
  nop
  jz   @f
  mov  al, 00Ah
  call @PrintChr
  @@:
  retn

@PrintHead:
  lea  si, [_Seq960LCols]
  mov  cx, 4
  nop
  call @PrintSeq
  retn

@CheckKey:
  push dx
  mov  ah, 001h
  int  016h
  jz   @f
  xor  ah, ah
  int  016h
  cmp  al, 01Bh
  jz   @CheckKey_ret
  call @PrintPause
  xor  ah, ah
  int  016h
  push ax
  call @PrintClear
  pop  ax
  cmp  al, 01Bh
  jz   @CheckKey_ret
  @@:
  xor  ax, ax
  pop  dx
  retn
  @CheckKey_ret:
  mov  ax, 1
  pop  dx
  retn

@PrintPause:
  push bx
  mov  dx, 01814h
  xor  bh, bh
  mov  ah, 002h
  int  010h
  lea  dx, [_StrWaitText]
  mov  ah, 009h
  int  021h
  pop  bx
  retn

@PrintClear:
  push bx
  mov  dx, 01814h
  xor  bh, bh
  mov  ah, 002h
  int  010h
  lea  dx, [_StrWaitFill]
  mov  ah, 009h
  int  021h
  pop  bx
  retn

_SeqSpacing8 db 01Bh, 041h, 008h, 00Dh
_SeqSpacing6 db 01Bh, 041h, 006h, 00Dh
_Seq960LCols db 01Bh, 04Ch, 0C0h, 003h
_SeqPrnReset db 01Bh, 040h, 01Bh, 039h, 01Bh, 04Fh, 00Dh
_StrWaitText db 'Pausing... Press a key to continue.$'
_StrWaitFill db '                                   $'
_BufSeg dw 0
_BufOfs dw 0
_BufLen dw 0
_PrnFlg db 0
