; FASM source code
; http://flatassembler.net/
;
; showcode.asm
; (c) SysTools 2019
; http://systools.losthost.org/
org 100h
  ; INT 16H: Keyboard Services
  ; AH = 00H - Read (Wait for) Next Keystroke
  mov  ah, 000h
  int  016h
  ; output: AH - scan code; AL - character code
  ; character
  mov  [_txt+6], al
  ; convert scan code value
  call @tohex
  mov  [_txt+1], dl ; str index 1, see below
  call @tohex
  mov  [_txt+0], dl
  ; convert char code value
  call @tohex
  mov  [_txt+4], dl
  call @tohex
  mov  [_txt+3], dl
  ; DOS Fn 09H: Display String
  mov  ah, 009h
  mov  dx, _txt
  int  021h
  ; DOS Fn 4cH: Terminate Program
  mov  ax, 04C00h
  int  021h
@tohex:
  mov  dl, al
  shr  ax, 004h
  and  dl, 00Fh
  cmp  dl, 9d
  jbe  @f
  add  dl, 'A' - '0' - 10d
  @@:
  add  dl, '0'
  ret
; index: 01 34 6
_txt db '## ## ?',00Dh,00Ah,'$'
