; FASM source code
; http://flatassembler.net/
;
; newskeyb.asm
; (c) SysTools 2019
; http://systools.losthost.org/
@head:
org 100h
  ; get interrupt vector 009h (keyboard)
  mov  ax, 03509h
  int  021h
  ; save original vector
  mov  [@vect9addr+1], bx
  mov  [@vect9addr+3], es
  ; set new interrupt vector
  mov  dx, @vect9hook
  mov  ax, 02509h ; keyboard
  int  021h
  ; move stack down before shrinking
  mov  bx, @tail
  mov  sp, bx
  ; save stack registers
  mov  [_sp], sp
  mov  [_ss], ss
  ; fill segments for @execparm
  mov  [_tcmd + 2], ds
  mov  [_fcb1 + 2], ds
  mov  [_fcb2 + 2], ds
  ; adjust memory block
  mov  ax, cs
  mov  es, ax
  ; bx - size in 16 bytes paragraphs
  mov  bx, ((SIZE + 15) / 16)
  mov  ah, 04Ah
  int  021h
  ; execute program
  mov  dx, _filename
  mov  bx, @execparm
  mov  ax, 04B00h
  int  021h
  ; restore stack registers
  cli
  mov  sp, [cs:_sp]
  mov  ss, [cs:_ss]
  sti
  ; restore interrupt
  mov  dx, [cs:@vect9addr+1]
  mov  ds, [cs:@vect9addr+3]
  mov  ax, 02509h ; keyboard
  int  021h
  ; exit program
  mov  ax, 04C00h
  int  021h

  ; hook procedure
align  2
@vect9hook:
  ; save registers in use
  push ax
  push bx
  push es
  push ds
  push di
  ; data segment
  mov  ax, cs
  mov  ds, ax
  ; BIOS segment
  mov  ax, 040h
  mov  es, ax
  ; first of all check that Scroll Lock is on
  test byte [es:00017h], 010h
  jz   @stop
  ; read the key
  in   al, 060h
  ; last key was extended - skip current one (E0 xx)
  cmp  [_flag], 0
  mov  [_flag], 0
  jnz  @stop
  ; extended key - skip it
  cmp  al, 0E0h
  jnz  @f
  mov  [_flag], 1
  jmp  @stop
  @@:
  ; check that key in range
  cmp  al, 035h
  ja   @stop
  xor  ah, ah
  mov  di, ax
  ; check if that key should be mapped
  cmp  [@key_lower+di], ah
  jz  @stop
  ; check keyboard buffer head/tail
  mov  bx, [es:0001Ch] ; tail
  ; 1A - head
  ; 1C - tail
  ; 1E - buff
  ; calculate next position
  sub  bl, 01Eh
  add  bl, 002h
  and  bl, 01Fh
  add  bl, 01Eh
  cmp  bx, [es:0001Ah] ; head
  ; buffer not full (next(tail) == head)
  jnz  @work
  ; keep all jumps short - move @stop code here
@stop:
  ; restore registers
  pop  di
  pop  ds
  pop  es
  pop  bx
  pop  ax
  ; jump to original interrupt
@vect9addr:
  ; if for some reason vector was not saved here - perform a cold reboot
  jmp  far 0F000h:0FFF0h
@work:
  ; at lest one Shift pressed
  xor  ah, ah
  test byte [es:0017h], 003h
  jz   @f
  xor  ah, 1
  @@:
  ; Caps Lock only for letters
  cmp  al, 010h
  jb   @f
  cmp  al, 034h
  ja   @f
  ; Caps Lock enabled
  test byte [es:0017h], 040h
  jz   @f
  xor  ah, 1
  @@:
  ; lower or upper case
  test ah, ah
  mov  ah, [@key_lower+di]
  jz   @f
  mov  ah, [@key_upper+di]
  @@:
  ; al - char; ah - code
  xchg al, ah
  ; move buffer tail
  xchg [es:0001Ch], bx
  ; put key to the buffer
  mov  [es:bx], ax
  ; interrupt cleanup
  in   al, 061h ; get value of keyboard control lines
  mov  ah, al   ; save it
  or   al, 080h ; set the "enable kbd" bit
  out  061h, al ; and write it out the control port
  xchg ah, al   ; fetch the original control port value
  out  061h, al ; and write it back
  ; send End-Of-Interrupt signal to the 8259 Interrupt Controller
  mov  al, 020h
  out  020h, al
  ; restore registers
  pop  di
  pop  ds
  pop  es
  pop  bx
  pop  ax
  ; interrupt return
  iret

; static data here
align  2
; scan codes from [00h..035h]
@key_lower:
db 000h, 000h, 031h, 032h, 033h, 034h, 035h, 036h
db 037h, 038h, 039h, 030h, 02Dh, 03Dh, 000h, 000h
db 06Ah, 063h, 075h, 06Bh, 065h, 06Eh, 067h, 07Bh
db 07Dh, 07Ah, 068h, 07Fh, 000h, 000h, 066h, 079h
db 077h, 061h, 070h, 072h, 06Fh, 06Ch, 064h, 076h
db 07Ch, 027h, 000h, 02Fh, 071h, 07Eh, 073h, 06Dh
db 069h, 074h, 078h, 062h, 060h, 02Eh
@key_upper:
db 000h, 000h, 021h, 022h, 023h, 03Bh, 025h, 03Ah
db 03Fh, 02Ah, 028h, 029h, 02Dh, 02Bh, 000h, 000h
db 04Ah, 043h, 055h, 04Bh, 045h, 04Eh, 047h, 05Bh
db 05Dh, 05Ah, 048h, 05Fh, 000h, 000h, 046h, 059h
db 057h, 041h, 050h, 052h, 04Fh, 04Ch, 044h, 056h
db 05Ch, 027h, 000h, 02Fh, 051h, 05Eh, 053h, 04Dh
db 049h, 054h, 058h, 042h, 040h, 02Ch
; padding _filename to 12 characters (8.3) format
; so anyone can replace 'NEWS.EXE' to the program
; name they might want without recompiling source
_filename db 'NEWS.EXE',0,0,0,0,0
_flag db 0
@execparm:
_eseg dw 0
_tcmd dw 080h, 0
_fcb1 dw 05Ch, 0
_fcb2 dw 06Ch, 0
; dynamic data here
_sp rw 1
_ss rw 1
; stack size: 32 bytes (should be enough)
_stack rb 32
align  16
; size of whole program (PSP + code + stack)
@tail:
SIZE = ($ - @head)
