#include <windows.h>

#ifndef TINYFILE
#include <stdio.h>
#else
/* some code to reduce executable size */
#define main _main

int main(void);

void mainCRTStartup(void) {
  ExitProcess(main());
}

int printf(const char *fmt, ...) {
DWORD i, j, k, dw;
HANDLE hout;
char s[1025];
va_list args;
  va_start(args, fmt);
  wvsprintf(s, fmt, args);
  va_end(args);
  hout = GetStdHandle(STD_OUTPUT_HANDLE);
  k = 0x0A0D;
  j = 0;
  for (i = 0; s[i]; i++) {
    if (s[i] == '\n') {
      WriteFile(hout, &s[j], i - j, &dw, NULL);
      j = i + 1;
      WriteFile(hout, &k, 2, &dw, NULL);
    }
  }
  WriteFile(hout, &s[j], i - j, &dw, NULL);
  return(0);
}
#endif

static char stString[] = "KERNEL32.dll\0""GetAtomA\0""CHOOSETOPICSDIALOGPROC\0""NOVEX!.NKD";
static char list_mod[] = "CALCS.DLL\0""HTBTWIN.EXE\0""HTVIEW.EXE\0""PRECNEW.EXE\0""TUNER.EXE\0";

/*
  /!\ WARNING /!\
  forced to encrypt xor_code[] and xor_find[] data to prevent people
  from modifing this tool to work without key or with invalid key
  because AstroLogos WILL *NOT* WORK CORRECTLY without original key data
*/

#define MAX_CODE 46
static BYTE xor_code[MAX_CODE] = {
  0x3C, 0x5A, 0x95, 0xA8, 0x78, 0x71, 0xD7, 0x87, 0x96, 0x74, 0x63,
  0x9D, 0xE6, 0xCD, 0x7D, 0xA1, 0xD2, 0x66, 0xD8, 0x92, 0x30, 0x24,
  0xFF, 0x64, 0xA4, 0x86, 0xA2, 0x68, 0x78, 0x35, 0xD8, 0x47, 0x0D,
  0x66, 0x26, 0xC7, 0x64, 0x7A, 0x43, 0x34, 0x97, 0x12, 0xBD, 0x02,
  0xFA, 0xF9
};

static DWORD xor_find[2] = {0x559590F0, 0xB95803F8};

/* https://mingw-users.narkive.com/OVMBC8XY/dlltool-g-problem */
HGLOBAL WINAPI GlobalAlloc16(UINT uFlags, DWORD dwBytes);
HGLOBAL WINAPI GlobalFree16(HGLOBAL hMem);
HINSTANCE WINAPI LoadLibrary16(LPCTSTR lpLibFileName);
BOOL WINAPI FreeLibrary16(HMODULE hLibModule);
FARPROC WINAPI GetProcAddress16(HMODULE hModule, LPCSTR lpProcName);
/* https://docs.microsoft.com/en-us/previous-versions/aa384016(v%3Dvs.85)
   https://docs.microsoft.com/en-us/previous-versions/aa384020(v%3Dvs.85) */
LPVOID WINAPI WOWGetVDMPointerFix(DWORD vp, DWORD dwBytes, BOOL fProtectedMode);
VOID WINAPI WOWGetVDMPointerUnfix(DWORD vp);
/*
  declare QT_Thunk() as get key routine
  edx must be proc addr to call
  stack - arguments
  eax - anything, just use stub[] here to prevent stack optimization
*/
DWORD __attribute__ ((regparm(2))) QT_Thunk(LPVOID eax_stub, FARPROC edx_proc, LPVOID data);

DWORD CallProc(FARPROC proc, LPVOID data) {
BYTE stub[1024]; /* required or QT_Thunk() will mess up program stack */
  return(QT_Thunk(stub/*eax*/, proc/*edx*/, data/*stack*/));
}

DWORD GetKeyHash(BYTE *key) {
DWORD r, i;
  r = 0;
  for (i = 0; i < 32; i++) {
    r ^= key[i];
    r  = (r << 5) | (r >> 27);
  }
  return(r);
}

void GetAsmCode(BYTE *d, BYTE *s, BYTE *k) {
DWORD i;
  for (i = 0; i < MAX_CODE; i++) {
    d[i] = s[i] ^ k[i % 32];
  }
}

DWORD GetALKey(BYTE *key) {
DWORD x, i;
HINSTANCE h;
FARPROC p;
LPVOID g;
char *s;
HANDLE f;
  ZeroMemory(key, 32);
  s = (char *) stString;
  /* Windows 9x lazy check */
  x = 0;
  h = (HINSTANCE) GetModuleHandle(s);
  s += lstrlen(s) + 1;
  if (h) {
    h = (GetProcAddress(h, s) == GetProcAddress(h, MAKEINTRESOURCE(50))) ? h : NULL;
  }
  s += lstrlen(s) + 1;
  /* load library */
  h = h ? LoadLibrary16(list_mod) : NULL;
  p = h ? GetProcAddress16(h, s) : NULL;
  g = p ? GlobalAlloc16(GPTR, 32) : NULL;
  if (h && p && g) {
    /* reverse seg:ofs */
    x = (DWORD) g;
    g = (LPVOID) MAKELONG(HIWORD(x), LOWORD(x));
    /* calc offset to the key reading function */
    x = (DWORD) WOWGetVDMPointerFix((DWORD) p, 0x44, TRUE);
    x += 0x40;
    /* get required segment */
    x = *((DWORD *) x);
    /* offset to the required routine */
    x += 0x62;
    WOWGetVDMPointerUnfix((DWORD) p);
    /* call get key */
    x = CallProc((FARPROC) x, g);
    /* zero - no error */
    if (!x) {
      CopyMemory(key, WOWGetVDMPointerFix(((DWORD) g), 32, TRUE), 32);
      WOWGetVDMPointerUnfix((DWORD) g);
      /* lazy check in case of a different LPT key */
      x = (GetKeyHash(key) ^ xor_find[0]) >> 24;
    }
  }
  if (g) { GlobalFree16(g); }
  if (h) { FreeLibrary16(h); }
  x  = x ? 1 : 0;
  x |= h ? 0 : 2;
  x |= p ? 0 : 4;
  x |= g ? 0 : 8;
  /* not LPT port or read error - fallback to read key from the key dump by NKDUMP.COM */
  if (x) {
    i = 0;
    s += lstrlen(s) + 1;
    f = CreateFile(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
    if (f != INVALID_HANDLE_VALUE) {
      /* lazy check of the key dump size */
      if (GetFileSize(f, NULL) == 512) {
        /* seek to the start of the key data */
        SetFilePointer(f, 0x1A, NULL, FILE_BEGIN);
        ReadFile(f, key, 32, &i, NULL);
      }
      CloseHandle(f);
    }
    /* got something */
    if (i == 32) {
      /* lazy check in case of a different LPT key */
      x = (GetKeyHash(key) ^ xor_find[0]) >> 24;
      x = x ? 16 : 0;
    }
  }
  /* bitmask to error code */
  i = 0;
  while (x) {
    i++;
    /* any first non-zero bit valid */
    if (x & 1) { break; }
    x >>= 1;
  }
  return(i);
}

DWORD PatchNovexKey(char *filename, BYTE *key, BOOL doit) {
DWORD result, sz, i, x, d[2];
BYTE *p, c[MAX_CODE];
HANDLE fl, fm;
  result = 0;
  i = doit ? PatchNovexKey(filename, key, FALSE) : 2;
  if (i == 2) {
    fl = CreateFile(filename, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      fm = CreateFileMapping(fl, NULL, PAGE_READWRITE, 0, 0, NULL);
      if (fm) {
        p = (BYTE *) MapViewOfFile(fm, FILE_MAP_WRITE, 0, 0, 0);
        if (p) {
          sz = GetFileSize(fl, NULL);
          /* new header offset */
          if (sz > (0x3C + 4)) {
            i = *((DWORD *) &p[0x3C]);
            if ((i + 2) < sz) {
              /* NE = New Executable format */
              if (*((WORD *) &p[i]) == 0x454E) {
                /* prepare data to find */
                x = GetKeyHash(key);
                for (i = 0; i < 2; i++) {
                  d[i] = xor_find[i] ^ x;
                }
                /* scan file */
                for (i = 0; i < (sz - MAX_CODE); i++) {
                  /* find unique sequence */
                  if (((*((DWORD *) &p[i])) & 0xFFFFFF) == d[0]) {
                    /* move back to start */
                    for (x = i; x > 0; x--) {
                      if ((*((DWORD *) &p[x])) == d[1]) {
                        break;
                      }
                    }
                    /* code found */
                    if (x) {
                      if (doit) {
                        printf(" %08lX", x);
                        /* prepare data to write */
                        GetAsmCode(c, (BYTE *) xor_code, key);
                        if (!result) {
                          /* first code */
                          CopyMemory(&p[x], &c[0], 4);
                        } else {
                          /* second code */
                          CopyMemory(&p[x], &c[4], MAX_CODE - 4);
                          CopyMemory(&p[x + MAX_CODE - 4], key, 32);
                        }
                      }
                      result++;
                    }
                  }
                }
              }
            }
          }
          UnmapViewOfFile(p);
        }
        CloseHandle(fm);
      }
      CloseHandle(fl);
    }
  }
  return(result);
}

int main(void) {
BYTE key[32];
DWORD i;
char *s;
  printf("AstroLogos NOVEX LPT static key patcher v1.0\n(c) SysTools 2013\nhttp://systools.losthost.org/?misc\n\n");
  i = GetALKey(key);
  if (!i) {
    s = (char *) list_mod;
    while (*s) {
      printf("%12s ...", s);
      printf(" %s\n", (PatchNovexKey(s, key, TRUE) == 2) ? "ready" : "error");
      s += lstrlen(s) + 1;
    }
  } else {
    printf(
      "Error: can't load NOVEX LPT key (code %lu)!\n\n"
      "Please make sure that:\n"
      "- This tool running from the installed AstroLogos /PROGS/ folder.\n"
      "- This tool running under Windows 95 OSR-2 / 98 / Me\n"
      "  and AstroLogos Novex LPT key inserted into LPT port.\n"
      "- *OR* correct AstroLogos Novex LPT key dump present in \"NOVEX!.NKD\" file.\n"
      "   Key dump can be created by \"NKDUMP.COM\" on the system with the LPT-port.\n"
      , i
    );
  }
  printf("\nPress [Enter] to continue.");
  ReadFile(GetStdHandle(STD_INPUT_HANDLE), key, 1, &i, NULL);
  return(0);
}
